# MovieBox API (Express)

API proxy sederhana untuk MovieBox, cocok untuk deploy di cPanel NodeJS.

## Setup

1) Copy `.env.example` menjadi `.env` dan sesuaikan nilai.
2) Install dependencies:

```bash
npm install
```

3) Jalankan server:

```bash
npm start
```

## Endpoints

- `GET /moviebox/homepage`
- `GET /moviebox/search?query=...`
- `GET /moviebox/detail?subjectId=...`
- `GET /moviebox/play?subjectId=...&detailPath=...&se=1&ep=1`
- `GET /moviebox/sources?subjectId=...`
- `GET /health`

## Notes

- Response adalah raw JSON dari upstream (tanpa enkripsi).
- Cache in-memory sederhana, TTL bisa diatur dari env `CACHE_TTL_MS`.
- Header request dibuat mirip browser untuk mengurangi block.

## cPanel NodeJS

- Set `Application startup file` ke `server.js`.
- Set `Application URL` sesuai kebutuhan.
- Set env di cPanel atau pakai `.env`.
