export class SimpleCache {
  constructor(ttlMs) {
    this.ttlMs = ttlMs;
    this.store = new Map();
  }

  get(key) {
    const entry = this.store.get(key);
    if (!entry) return null;
    if (entry.expiresAt < Date.now()) {
      this.store.delete(key);
      return null;
    }
    return entry.value;
  }

  set(key, value, ttlOverrideMs) {
    const ttl = typeof ttlOverrideMs === "number" ? ttlOverrideMs : this.ttlMs;
    this.store.set(key, { value, expiresAt: Date.now() + ttl });
  }
}
